DROP TABLE IF EXISTS `admin_access_group_descriptions`;
CREATE TABLE `admin_access_group_descriptions` (
	`admin_access_group_id` INT(11) UNSIGNED NOT NULL DEFAULT '0',
	`language_id` int(11) NOT NULL DEFAULT '1',
	`name` varchar(255) NOT NULL DEFAULT '',
	`description` text NOT NULL,
	PRIMARY KEY (`admin_access_group_id`, `language_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO admin_access_group_descriptions (admin_access_group_id, language_id, name, description) VALUES
(1, 1, 'API', 'Allows the general usage of the shop API. This permission may be necessary for some inventory management system.'),
(1, 2, 'API', 'Erlaubt die generelle Nutzung der API. Dies wird z.B. zur Nutzung einiger Warenwirtschaftssysteme benötigt.'),
(2, 1, 'Gambio Admin Web UI', 'Allows the general usage of the Gambio Admin web interface and access to the Gambio news.'),
(2, 2, 'Gambio Admin Web UI', 'Erlaubt die generelle Nutzung der Gambio Admin Weboberfläche und Zugriff auf die Gambio News.'),
(3, 1, 'Orders', 'Allows the management of the orders.'),
(3, 2, 'Bestellungen', 'Erlaubt die Verwaltung von Bestellungen.'),
(4, 1, 'Withdrawals', 'Allows the access to the withdrawals.'),
(4, 2, 'Widerrufe', 'Erlaubt den Zugriff auf die Widerrufe.'),
(5, 1, 'Invoices', 'Allows the access to the invoices.'),
(5, 2, 'Rechnungen', 'Erlaubt den Zugriff auf die Rechnungen.'),
(6, 1, 'Customers', 'Allows the management of the customers.'),
(6, 2, 'Kunden', 'Erlaubt die Verwaltung von Kunden.'),
(7, 1, 'Customer Groups', 'Allows the management of the customer groups.'),
(7, 2, 'Kundengruppen', 'Erlaubt die Verwaltung von Kundengruppen.'),
(8, 1, 'Emails', 'Allows the management of the emails.'),
(8, 2, 'E-Mails', 'Erlaubt die Verwaltung von E-Mails.'),
(9, 1, 'Roles and Permissions', 'Allows the management of the admin access permissions.'),
(9, 2, 'Rollen und Berechtigungen', 'Erlaubt die Verwaltung von Zugriffsrechten.'),
(10, 1, 'Google', 'Allows the usage of the Google service.'),
(10, 2, 'Google', 'Erlaubt die Nutzung des Google Services. '),
(11, 1, 'Catalog', 'Allows the management of products, categories, special prices, attributes, properties and product filters.'),
(11, 2, 'Artikel', 'Erlaubt die Verwaltung von Artikeln, Kategorien, Sonderangeboten, Eigenschaften, Attributen und Artikel-Filter. '),
(12, 1, 'QuickEdit', 'Allows the usage of the QuickEdit.'),
(12, 2, 'QuickEdit', 'Erlaubt die Nutzung von QuickEdit.'),
(13, 1, 'Manufacturers', 'Allows the access to the manufacturers.'),
(13, 2, 'Hersteller', 'Erlaubt den Zugriff auf die Hersteller.'),
(14, 1, 'Packing Unit', 'Allows the access to the packing units.'),
(14, 2, 'Verpackungseinheiten', 'Erlaubt den Zugriff auf die Verpackungseinheiten.'),
(15, 1, 'Quantity Units', 'Allows the access to the quantity units.'),
(15, 2, 'Mengeneinheiten', 'Erlaubt den Zugriff auf die Mengeneinheiten.'),
(16, 1, 'GX-Customizer', 'Allows the access to the GX-Customizer.'),
(16, 2, 'GX-Customizer', 'Erlaubt den Zugriff auf den GX-Customizer.'),
(17, 1, 'Cross-selling Groups', 'Allows the access to the cross-selling groups.'),
(17, 2, 'Cross-Marketing Gruppen', 'Erlaubt den Zugriff auf die Cross-Marketing Gruppen.'),
(18, 1, 'Product Reviews', 'Allows the access to the product reviews.'),
(18, 2, 'Kundenrezensionen', 'Erlaubt den Zugriff auf die Kundenrezensionen.'),
(19, 1, 'Content', 'Allows the general usage of layout and design options and content management.'),
(19, 2, 'Inhalte', 'Erlaubt die generelle Nutzung von Darstellungsoptionen und Verwaltung von Inhalten.'),
(20, 1, 'Template Settings', 'Allows the management of the templates options and logos.'),
(20, 2, 'Template-Einstellungen', 'Erlaubt die Verwaltung der Templates und Logos.'),
(21, 1, 'Logo Manager', 'Allows the usage of the logo manager.'),
(21, 2, 'Logo Manager', 'Erlaubt die Nutzung des Logo Managers.'),
(22, 1, 'Teaser Slider', 'Allows the management of the sliders.'),
(22, 2, 'Teaser Slider', 'Erlaubt die Verwaltung von Slidern.'),
(23, 1, 'Content Manager', 'Allows the management of shop contents with the content manager.'),
(23, 2, 'Content Manager', 'Erlaubt die Verwaltung der Shop Inhalte mit dem Content Manager.'),
(24, 1, 'Shop online/offline', 'Allows the management of the "Shop online/offline" options.'),
(24, 2, 'Shop online/offline', 'Erlaubt die Verwaltung der "Shop online/offline" Einstellungen.'),
(25, 1, 'Banner Manager', 'Allows the usage of the banner manager.'),
(25, 2, 'Banner Manager', 'Erlaubt die Nutzung des Banner Managers.'),
(26, 1, 'Image Processing', 'Allows the usage of the image processing.'),
(26, 2, 'Image Processing', 'Erlaubt die Nutzung des Image Processings.'),
(27, 1, 'Toolbox', 'Allows the general usage of the tools in the toolbox.'),
(27, 2, 'Toolbox', 'Erlaubt die generelle Nutzung der Tools der Toolbox.'),
(28, 1, 'Cache', 'Allows the management of the caching system.'),
(28, 2, 'Cache', 'Erlaubt die Verwaltung des Caching-Systems.'),
(29, 1, 'Timer', 'Allows the management of the timers.'),
(29, 2, 'Timer', 'Erlaubt die Verwaltung der Timer.'),
(31, 1, 'Edit text phrases', 'Allows the management of the shop text phrases'),
(31, 2, 'Texte anpassen', 'Erlaubt die Verwaltung der Shop-Texte.'),
(32, 1, 'Newsletter', 'Allows the management of the newsletters.'),
(32, 2, 'Newsletter', 'Erlaubt die Verwaltung der Newsletter.'),
(33, 1, 'Database Manager', 'Allows the usage of the database manager.'),
(33, 2, 'Datenbanksicherung', 'Erlaubt die Nutzung der Datenbanksicherung.'),
(34, 1, 'Backup files', 'Allows the access to the backup files.'),
(34, 2, 'Dateien sichern', 'Erlaubt den Zugriff auf die Backup-Dateien.'),
(35, 1, 'Logs', 'Allows the management of the server logs.'),
(35, 2, 'Logs', 'Erlaubt die Verwaltung der Serverlogs.'),
(36, 1, 'Server info', 'Allows the access to the server information.'),
(36, 2, 'Server Info', 'Erlaubt die Einsicht in die Serverinformationen.'),
(37, 1, 'SQL', 'Allows the usage of the phpMiniAdmin.'),
(37, 2, 'SQL', 'Erlaubt die Nutzung des phpMiniAdmins.'),
(38, 1, 'File Manager', 'Allows the usage of the FileManager.'),
(38, 2, 'File Manager', 'Erlaubt die Nutzung des FileManagers.'),
(39, 1, 'Modules', 'Allows the general usage of modules from the module center.'),
(39, 2, 'Module', 'Erlaubt die generelle Nutzung von Modulen aus dem Modul-Center.'),
(40, 1, 'Module Center', 'Allows the management of modules with the module center.'),
(40, 2, 'Modul-Center', 'Erlaubt die Verwaltung von Modulen über das Modul-Center.'),
(41, 1, 'Shipping Methods, Payment Systems and Order Total', 'Allows the management of shipping, payment and order total modules.'),
(41, 2, 'Versandarten, Zahlungsweisen und Zusammenfassung', 'Erlaubt die Verwaltung von Versand-, Zahlungs- und Zusammenfassungs-Modulen.'),
(42, 1, 'Statistics', 'Allows the access to the statistics.'),
(42, 2, 'Statistiken', 'Erlaubt die Einsicht in die Statistiken.'),
(43, 1, 'Import / Export', 'Allows the usage of imports and exports.'),
(43, 2, 'Import / Export', 'Erlaubt die Nutzung des Import und Exports.'),
(46, 1, 'Vouchers', 'Allows the managements of vouchers.'),
(46, 2, 'Gutscheine', 'Erlaubt die Verwaltung von Gutscheinen.'),
(47, 1, 'Shop Settings', 'Allows the general access to the shop options.'),
(47, 2, 'Shop Einstellungen', 'Erlaubt den generellen Zugriff auf die Shop Einstellungen.'),
(50, 1, 'Shipping status', 'Allows the management of the shipping status of the shop.'),
(50, 2, 'Lieferstatus', 'Erlaubt die Verwaltung der Lieferstatus des Shops.'),
(51, 1, 'Parcel services', 'Allows the management of the parcel services of the shop.'),
(51, 2, 'Paketdienste', 'Erlaubt die Verwaltung der Paketdienste des Shops.'),
(52, 1, 'Start IDs', 'Allows the management of the starting ids of the shop.'),
(52, 2, 'Nummernkreise', 'Erlaubt die Verwaltung der Start IDs des Shops.'),
(53, 1, 'SEO', 'Allows the management of the SEO options of the shop.'),
(53, 2, 'SEO', 'Erlaubt die Verwaltung der SEO-Einstellungen des Shops.'),
(54, 1, 'Zone & Tax', 'Allows the management of zones and taxes.'),
(54, 2, 'Zonen & Steuern', 'Erlaubt die Verwaltung von Zonen und Steuern.'),
(56, 1, 'Hub', 'Allows the management of the Gambio Hub.'),
(56, 2, 'Hub', 'Erlaubt die Verwaltung des Gambio Hubs.'),
(57, 1, 'Gambio Store', 'Allows the usage of the Gambio Store.'),
(57, 2, 'Gambio Store', 'Erlaubt die Nutzung des Gambio Stores.'),
(58, 1, 'Google Shopping', 'Allows the usage of Google Shopping.'),
(58, 2, 'Google Shopping', 'Erlaubt die Nutzung von Google Shopping.'),
(59, 1, 'Google Ads', 'Allows the usage of Google Ads.'),
(59, 2, 'Google Ads', 'Erlaubt die Nutzung von Google Ads.'),
(60, 1, 'Google Analytics', 'Allows the usage of Google Analytics.'),
(60, 2, 'Google Analytics', 'Erlaubt die Nutzung von Google Analytics.'),
(62, 1, 'StyleEdit', 'Allows the usage of StyleEdit3 and StyleEdit4'),
(62, 2, 'StyleEdit', 'Erlaubt die Nutzung von StyleEdit3 und StyleEdit4'),
(63, 2, 'Zeitgesteuerte Aufgaben', 'Erlaubt die Nutzung der zeitgesteuerten Aufgaben.'),
(63, 1, 'Scheduled tasks', 'Allows the use of the scheduled tasks.'),
(64, 1, 'User friendly error pages', 'Allows the use of the user friendly error pages.'),
(64, 2, 'Eigene Fehlerseiten', 'Erlaubt die Nutzung der eigenen Fehlerseiten.'),
(65, 1, 'Unknown modules', 'This permission combines all unknown modules. It is recommended to grant this permission.'),
(65, 2, 'Unbekannte Module', 'Diese Berechtigung fasst alle unbekannten Module zusammen. Es wird empfohlen, dass diese Berechtigung immer erlaubt wird.'),
(66, 1, 'Redirection rules', 'Allows the management of redirection rules.'),
(66, 2, 'Weiterleitungsregeln', 'Erlaubt die Verwaltung von Weiterleitungsregeln.');


